/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.PacketDistributor;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.contributor.ITierProvider;
import snownee.kiwi.contributor.client.RewardLayer;
import snownee.kiwi.contributor.client.gui.RewardScreen;
import snownee.kiwi.contributor.impl.KiwiRewardProvider;
import snownee.kiwi.contributor.network.CSetEffectPacket;
import snownee.kiwi.contributor.network.SSyncEffectPacket;
import snownee.kiwi.network.NetworkChannel;
import snownee.kiwi.util.Util;

@KiwiModule(value="contributors")
@KiwiModule.Subscriber
public class Contributors
extends AbstractModule {
    public static final Map<String, ITierProvider> REWARD_PROVIDERS = Maps.newConcurrentMap();
    public static final Map<String, ResourceLocation> PLAYER_EFFECTS = Maps.newConcurrentMap();
    private static final Set<ResourceLocation> RENDERABLES = Sets.newLinkedHashSet();
    private static int DAY = Calendar.getInstance().get(5);
    private int hold;

    @Override
    protected void preInit() {
        NetworkChannel.register(CSetEffectPacket.class, new CSetEffectPacket.Handler());
        NetworkChannel.register(SSyncEffectPacket.class, new SSyncEffectPacket.Handler());
    }

    @Override
    protected void init(FMLCommonSetupEvent event) {
        Contributors.registerTierProvider(new KiwiRewardProvider());
    }

    public static boolean isContributor(String author, String playerName) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName);
    }

    public static boolean isContributor(String author, String playerName, String tier) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName, tier);
    }

    public static boolean isContributor(String author, PlayerEntity player) {
        return Contributors.isContributor(author, player.func_146103_bH().getName());
    }

    public static boolean isContributor(String author, PlayerEntity player, String tier) {
        return Contributors.isContributor(author, player.func_146103_bH().getName(), tier);
    }

    public static Set<ResourceLocation> getPlayerTiers(String playerName) {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getPlayerTiers(playerName).stream().map(s -> new ResourceLocation(tp.getAuthor().toLowerCase(Locale.ENGLISH), s))).collect(Collectors.toSet());
    }

    public static Set<ResourceLocation> getTiers() {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getTiers().stream().map(s -> new ResourceLocation(tp.getAuthor().toLowerCase(Locale.ENGLISH), s))).collect(Collectors.toSet());
    }

    public static void registerTierProvider(ITierProvider rewardProvider) {
        String namespace = rewardProvider.getAuthor().toLowerCase(Locale.ENGLISH);
        REWARD_PROVIDERS.put(namespace, rewardProvider);
        for (String tier : rewardProvider.getRenderableTiers()) {
            RENDERABLES.add(new ResourceLocation(namespace, tier));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity().field_70170_p instanceof ServerWorld)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!((ServerWorld)event.getEntity().field_70170_p).func_73046_m().func_213199_b(player.func_146103_bH())) {
            new SSyncEffectPacket(PLAYER_EFFECTS).send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        Contributors.changeEffect();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PLAYER_EFFECTS.remove(event.getPlayer().func_146103_bH().getName());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        PLAYER_EFFECTS.clear();
        RewardLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(FMLClientSetupEvent event) {
        Minecraft.func_71410_x().func_175598_ae().getSkinMap().values().forEach(renderer -> {
            RewardLayer layer = new RewardLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderer);
            RewardLayer.ALL_LAYERS.add(layer);
            renderer.func_177094_a((LayerRenderer)layer);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changeEffect() {
        ResourceLocation id = Util.RL(KiwiClientConfig.contributorEffect);
        if (id != null && id.func_110623_a().isEmpty()) {
            id = null;
        }
        ResourceLocation effect = id;
        Contributors.canPlayerUseEffect(Contributors.getPlayerName(), effect).thenAccept(bl -> {
            if (!bl.booleanValue()) {
                ConfigHandler cfg = KiwiConfigManager.getHandler(KiwiClientConfig.class);
                ForgeConfigSpec.ConfigValue<?> val = cfg.getValueByPath("contributorEffect");
                val.set((Object)"");
                cfg.refresh();
                return;
            }
            new CSetEffectPacket(effect).send();
            if (effect == null) {
                PLAYER_EFFECTS.remove(Contributors.getPlayerName());
            } else {
                PLAYER_EFFECTS.put(Contributors.getPlayerName(), effect);
                Kiwi.logger.info("Enabled contributor effect: {}", (Object)effect);
            }
            RewardLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidate((Object)Contributors.getPlayerName()));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changeEffect(Map<String, ResourceLocation> changes) {
        changes.forEach((k, v) -> {
            if (v == null) {
                PLAYER_EFFECTS.remove(k);
            } else {
                PLAYER_EFFECTS.put((String)k, (ResourceLocation)v);
            }
        });
        RewardLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll(changes.keySet()));
    }

    public static void changeEffect(ServerPlayerEntity player, ResourceLocation effect) {
        String playerName = player.func_146103_bH().getName();
        Contributors.canPlayerUseEffect(playerName, effect).thenAccept(bl -> {
            if (bl.booleanValue()) {
                if (effect == null) {
                    PLAYER_EFFECTS.remove(playerName);
                } else {
                    PLAYER_EFFECTS.put(playerName, effect);
                }
                new SSyncEffectPacket((Map<String, ResourceLocation>)ImmutableMap.of((Object)playerName, (Object)effect)).sendExcept(player);
            }
        });
    }

    public static boolean isRenderable(ResourceLocation id) {
        Contributors.refreshRenderables();
        return RENDERABLES.contains(id);
    }

    public static Set<ResourceLocation> getRenderableTiers() {
        Contributors.refreshRenderables();
        return Collections.unmodifiableSet(RENDERABLES);
    }

    private static void refreshRenderables() {
        int current = Calendar.getInstance().get(5);
        if (current != DAY) {
            DAY = current;
            RENDERABLES.clear();
            for (Map.Entry<String, ITierProvider> entry : REWARD_PROVIDERS.entrySet()) {
                String namespace = entry.getKey();
                for (String tier : entry.getValue().getRenderableTiers()) {
                    RENDERABLES.add(new ResourceLocation(namespace, tier));
                }
            }
        }
    }

    public static CompletableFuture<Boolean> canPlayerUseEffect(String playerName, ResourceLocation effect) {
        if (effect == null || effect.func_110623_a().isEmpty()) {
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        if (!Contributors.isRenderable(effect)) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        ITierProvider provider = REWARD_PROVIDERS.getOrDefault(effect.func_110624_b().toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE);
        if (!provider.isContributor(playerName, effect.func_110623_a())) {
            if (FMLEnvironment.dist.isDedicatedServer()) {
                return provider.refresh().thenApply($ -> provider.isContributor(playerName, effect.func_110623_a()));
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getPlayerName() {
        return Minecraft.func_71410_x().func_110432_I().func_111285_a();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null || mc.field_71439_g == null || !mc.func_195544_aj()) {
            return;
        }
        if (event.getModifiers() != 0) {
            return;
        }
        InputMappings.Input input = InputMappings.func_197954_a((int)event.getKey(), (int)event.getScanCode());
        if (input.func_197937_c() != 75) {
            return;
        }
        if (event.getAction() != 2) {
            this.hold = 0;
        } else if (++this.hold == 30) {
            RewardScreen screen = new RewardScreen();
            mc.func_147108_a((Screen)screen);
        }
    }
}

